/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.handshake;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.registries.ForgeRegistry;

public abstract class FMLHandshakeMessage {
    public static FMLProxyPacket makeCustomChannelRegistration(Set<String> channels) {
        String salutation = Joiner.on((char)'\u0000').join(Iterables.concat(Arrays.asList("FML|HS", "FML", "FML|MP"), channels));
        FMLProxyPacket proxy = new FMLProxyPacket(new gy(Unpooled.wrappedBuffer((byte[])salutation.getBytes(StandardCharsets.UTF_8))), "REGISTER");
        return proxy;
    }

    public void fromBytes(ByteBuf buffer) {
    }

    public void toBytes(ByteBuf buffer) {
    }

    public String toString(Class<? extends Enum<?>> side) {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(36));
    }

    public static class HandshakeReset
    extends FMLHandshakeMessage {
    }

    public static class HandshakeAck
    extends FMLHandshakeMessage {
        int phase;

        public HandshakeAck() {
        }

        HandshakeAck(int phase) {
            this.phase = phase;
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.phase = buffer.readByte();
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(this.phase);
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":{" + this.phase + "}";
        }
    }

    public static class RegistryData
    extends FMLHandshakeMessage {
        private boolean hasMore;
        private nf name;
        private Map<nf, Integer> ids;
        private Set<nf> dummied;
        private Map<nf, String> overrides;

        public RegistryData() {
        }

        public RegistryData(boolean hasMore, nf name, ForgeRegistry.Snapshot entry) {
            this.hasMore = hasMore;
            this.name = name;
            this.ids = entry.ids;
            this.dummied = entry.dummied;
            this.overrides = entry.overrides;
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            int i2;
            this.hasMore = buffer.readBoolean();
            this.name = new nf(ByteBufUtils.readUTF8String(buffer));
            int length = ByteBufUtils.readVarInt(buffer, 3);
            this.ids = Maps.newHashMap();
            for (i2 = 0; i2 < length; ++i2) {
                this.ids.put(new nf(ByteBufUtils.readUTF8String(buffer)), ByteBufUtils.readVarInt(buffer, 3));
            }
            length = ByteBufUtils.readVarInt(buffer, 3);
            this.dummied = Sets.newHashSet();
            for (i2 = 0; i2 < length; ++i2) {
                this.dummied.add(new nf(ByteBufUtils.readUTF8String(buffer)));
            }
            length = ByteBufUtils.readVarInt(buffer, 3);
            this.overrides = Maps.newHashMap();
            for (i2 = 0; i2 < length; ++i2) {
                this.overrides.put(new nf(ByteBufUtils.readUTF8String(buffer)), ByteBufUtils.readUTF8String(buffer));
            }
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeBoolean(this.hasMore);
            ByteBufUtils.writeUTF8String(buffer, this.name.toString());
            ByteBufUtils.writeVarInt(buffer, this.ids.size(), 3);
            for (Map.Entry<nf, Integer> entry : this.ids.entrySet()) {
                ByteBufUtils.writeUTF8String(buffer, entry.getKey().toString());
                ByteBufUtils.writeVarInt(buffer, entry.getValue(), 3);
            }
            ByteBufUtils.writeVarInt(buffer, this.dummied.size(), 3);
            for (nf nf2 : this.dummied) {
                ByteBufUtils.writeUTF8String(buffer, nf2.toString());
            }
            ByteBufUtils.writeVarInt(buffer, this.overrides.size(), 3);
            for (Map.Entry<nf, Object> entry : this.overrides.entrySet()) {
                ByteBufUtils.writeUTF8String(buffer, entry.getKey().toString());
                ByteBufUtils.writeUTF8String(buffer, ((String)entry.getValue()).toString());
            }
        }

        public Map<nf, Integer> getIdMap() {
            return this.ids;
        }

        public Set<nf> getDummied() {
            return this.dummied;
        }

        public Map<nf, String> getOverrides() {
            return this.overrides;
        }

        public nf getName() {
            return this.name;
        }

        public boolean hasMore() {
            return this.hasMore;
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":" + this.ids.size() + " mappings";
        }
    }

    public static class ModList
    extends FMLHandshakeMessage {
        private Map<String, String> modTags = Maps.newHashMap();

        public ModList() {
        }

        public ModList(List<ModContainer> modList) {
            for (ModContainer mod : modList) {
                this.modTags.put(mod.getModId(), mod.getVersion());
            }
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            super.toBytes(buffer);
            ByteBufUtils.writeVarInt(buffer, this.modTags.size(), 2);
            for (Map.Entry<String, String> modTag : this.modTags.entrySet()) {
                ByteBufUtils.writeUTF8String(buffer, modTag.getKey());
                ByteBufUtils.writeUTF8String(buffer, modTag.getValue());
            }
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            super.fromBytes(buffer);
            int modCount = ByteBufUtils.readVarInt(buffer, 2);
            for (int i2 = 0; i2 < modCount; ++i2) {
                this.modTags.put(ByteBufUtils.readUTF8String(buffer), ByteBufUtils.readUTF8String(buffer));
            }
        }

        public String modListAsString() {
            return Joiner.on((char)',').withKeyValueSeparator("@").join(this.modTags);
        }

        public int modListSize() {
            return this.modTags.size();
        }

        public Map<String, String> modList() {
            return this.modTags;
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":" + this.modTags.size() + " mods";
        }
    }

    public static class ClientHello
    extends FMLHandshakeMessage {
        private byte serverProtocolVersion;

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(2);
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.serverProtocolVersion = buffer.readByte();
        }

        public byte protocolVersion() {
            return this.serverProtocolVersion;
        }
    }

    public static class ServerHello
    extends FMLHandshakeMessage {
        private byte serverProtocolVersion;
        private int overrideDimension;

        public ServerHello() {
        }

        public ServerHello(int overrideDim) {
            this.overrideDimension = overrideDim;
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(2);
            buffer.writeInt(this.overrideDimension);
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.serverProtocolVersion = buffer.readByte();
            if (this.serverProtocolVersion > 1) {
                this.overrideDimension = buffer.readInt();
                FMLLog.log.debug("Server FML protocol version {}, 4 byte dimension received {}", (Object)this.serverProtocolVersion, (Object)this.overrideDimension);
            } else {
                FMLLog.log.info("Server FML protocol version {}, no additional data received", (Object)this.serverProtocolVersion);
            }
        }

        public byte protocolVersion() {
            return this.serverProtocolVersion;
        }

        public int overrideDim() {
            return this.overrideDimension;
        }
    }
}

