/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import javax.annotation.Nullable;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LivingSpawnEvent
extends LivingEvent {
    private final amu world;
    private final float x;
    private final float y;
    private final float z;

    public LivingSpawnEvent(vq entity, amu world, float x, float y, float z) {
        super((vp)entity);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public amu getWorld() {
        return this.world;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    @Event.HasResult
    public static class AllowDespawn
    extends LivingSpawnEvent {
        public AllowDespawn(vq entity) {
            super(entity, entity.l, (float)entity.p, (float)entity.q, (float)entity.r);
        }
    }

    @Cancelable
    public static class SpecialSpawn
    extends LivingSpawnEvent {
        @Nullable
        private final amk spawner;

        @Deprecated
        public SpecialSpawn(vq entity, amu world, float x, float y, float z) {
            super(entity, world, x, y, z);
            this.spawner = null;
        }

        public SpecialSpawn(vq entity, amu world, float x, float y, float z, @Nullable amk spawner) {
            super(entity, world, x, y, z);
            this.spawner = spawner;
        }

        @Nullable
        public amk getSpawner() {
            return this.spawner;
        }
    }

    @Event.HasResult
    public static class CheckSpawn
    extends LivingSpawnEvent {
        private final boolean isSpawner;
        @Nullable
        private final amk spawner;

        public CheckSpawn(vq entity, amu world, float x, float y, float z, @Nullable amk spawner) {
            super(entity, world, x, y, z);
            this.isSpawner = spawner != null;
            this.spawner = spawner;
        }

        @Deprecated
        public CheckSpawn(vq entity, amu world, float x, float y, float z, boolean isSpawner) {
            super(entity, world, x, y, z);
            this.isSpawner = isSpawner;
            this.spawner = null;
        }

        @Deprecated
        public CheckSpawn(vq entity, amu world, float x, float y, float z) {
            this(entity, world, x, y, z, true);
        }

        public boolean isSpawner() {
            return this.isSpawner;
        }

        @Nullable
        public amk getSpawner() {
            return this.spawner;
        }
    }
}

