/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Quat4f;
import net.minecraftforge.client.model.BakedItemModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLLog;

public final class ModelDynBucket
implements IModel {
    public static final cgd LOCATION = new cgd(new nf("forge", "dynbucket"), "inventory");
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final IModel MODEL = new ModelDynBucket();
    @Nullable
    private final nf baseLocation;
    @Nullable
    private final nf liquidLocation;
    @Nullable
    private final nf coverLocation;
    @Nullable
    private final Fluid fluid;
    private final boolean flipGas;
    private final boolean tint;

    public ModelDynBucket() {
        this(null, null, null, null, false, true);
    }

    @Deprecated
    public ModelDynBucket(@Nullable nf baseLocation, @Nullable nf liquidLocation, @Nullable nf coverLocation, @Nullable Fluid fluid, boolean flipGas) {
        this(baseLocation, liquidLocation, coverLocation, fluid, flipGas, true);
    }

    public ModelDynBucket(@Nullable nf baseLocation, @Nullable nf liquidLocation, @Nullable nf coverLocation, @Nullable Fluid fluid, boolean flipGas, boolean tint) {
        this.baseLocation = baseLocation;
        this.liquidLocation = liquidLocation;
        this.coverLocation = coverLocation;
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.tint = tint;
    }

    @Override
    public Collection<nf> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.baseLocation != null) {
            builder.add((Object)this.baseLocation);
        }
        if (this.liquidLocation != null) {
            builder.add((Object)this.liquidLocation);
        }
        if (this.coverLocation != null) {
            builder.add((Object)this.coverLocation);
        }
        if (this.fluid != null) {
            builder.add((Object)this.fluid.getStill());
        }
        return builder.build();
    }

    @Override
    public cfy bake(IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
        ImmutableMap<bwc.b, TRSRTransformation> transformMap = PerspectiveMapWrapper.getTransforms(state);
        if (this.flipGas && this.fluid != null && this.fluid.isLighterThanAir()) {
            state = new ModelStateComposition(state, TRSRTransformation.blockCenterToCorner(new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        cdq fluidSprite = null;
        cdq particleSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid != null) {
            fluidSprite = bakedTextureGetter.apply(this.fluid.getStill());
        }
        if (this.baseLocation != null) {
            cfy model = new ItemLayerModel((ImmutableList<nf>)ImmutableList.of((Object)this.baseLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.a(null, null, 0L));
            particleSprite = model.d();
        }
        if (this.liquidLocation != null && fluidSprite != null) {
            cdq liquid = bakedTextureGetter.apply(this.liquidLocation);
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.468625f, fa.c, this.tint ? this.fluid.getColor() : -1, 1));
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.531375f, fa.d, this.tint ? this.fluid.getColor() : -1, 1));
            particleSprite = fluidSprite;
        }
        if (this.coverLocation != null) {
            cdq cover = bakedTextureGetter.apply(this.coverLocation);
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.4685f, cover, fa.c, -1, 2));
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.5315f, cover, fa.d, -1, 2));
            if (particleSprite == null) {
                particleSprite = cover;
            }
        }
        return new BakedDynBucket(this, (ImmutableList<bvp>)builder.build(), particleSprite, format, (ImmutableMap<bwc.b, TRSRTransformation>)Maps.immutableEnumMap(transformMap), Maps.newHashMap(), transform.isIdentity());
    }

    @Override
    public ModelDynBucket process(ImmutableMap<String, String> customData) {
        String fluidName = (String)customData.get((Object)"fluid");
        Fluid fluid = FluidRegistry.getFluid(fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        boolean flip = this.flipGas;
        if (customData.containsKey((Object)"flipGas")) {
            String flipStr = (String)customData.get((Object)"flipGas");
            if (flipStr.equals("true")) {
                flip = true;
            } else if (flipStr.equals("false")) {
                flip = false;
            } else {
                throw new IllegalArgumentException(String.format("DynBucket custom data \"flipGas\" must have value 'true' or 'false' (was '%s')", flipStr));
            }
        }
        boolean tint = this.tint;
        if (customData.containsKey((Object)"applyTint")) {
            String string;
            switch (string = (String)customData.get((Object)"applyTint")) {
                case "true": {
                    tint = true;
                    break;
                }
                case "false": {
                    tint = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("DynBucket custom data \"applyTint\" must have value 'true' or 'false' (was '%s')", string));
                }
            }
        }
        return new ModelDynBucket(this.baseLocation, this.liquidLocation, this.coverLocation, fluid, flip, tint);
    }

    @Override
    public ModelDynBucket retexture(ImmutableMap<String, String> textures) {
        nf base = this.baseLocation;
        nf liquid = this.liquidLocation;
        nf cover = this.coverLocation;
        if (textures.containsKey((Object)"base")) {
            base = new nf((String)textures.get((Object)"base"));
        }
        if (textures.containsKey((Object)"fluid")) {
            liquid = new nf((String)textures.get((Object)"fluid"));
        }
        if (textures.containsKey((Object)"cover")) {
            cover = new nf((String)textures.get((Object)"cover"));
        }
        return new ModelDynBucket(base, liquid, cover, this.fluid, this.flipGas, this.tint);
    }

    private static final class BakedDynBucket
    extends BakedItemModel {
        private final ModelDynBucket parent;
        private final Map<String, cfy> cache;
        private final cea format;

        BakedDynBucket(ModelDynBucket parent, ImmutableList<bvp> quads, cdq particle, cea format, ImmutableMap<bwc.b, TRSRTransformation> transforms, Map<String, cfy> cache, boolean untransformed) {
            super(quads, particle, transforms, BakedDynBucketOverrideHandler.INSTANCE, untransformed);
            this.format = format;
            this.parent = parent;
            this.cache = cache;
        }
    }

    private static final class BakedDynBucketOverrideHandler
    extends bwa {
        public static final BakedDynBucketOverrideHandler INSTANCE = new BakedDynBucketOverrideHandler();

        private BakedDynBucketOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public cfy handleItemState(cfy originalModel, aip stack, @Nullable amu world, @Nullable vp entity) {
            FluidStack fluidStack = FluidUtil.getFluidContained(stack);
            if (fluidStack == null) {
                return originalModel;
            }
            BakedDynBucket model = (BakedDynBucket)originalModel;
            Fluid fluid = fluidStack.getFluid();
            String name = fluid.getName();
            if (!model.cache.containsKey(name)) {
                IModel parent = model.parent.process(ImmutableMap.of((Object)"fluid", (Object)name));
                Function<nf, cdq> textureGetter = location -> bib.z().R().a(location.toString());
                cfy bakedModel = parent.bake(new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)model.transforms), model.format, textureGetter);
                model.cache.put(name, bakedModel);
                return bakedModel;
            }
            return (cfy)model.cache.get(name);
        }
    }

    private static final class BucketCoverSprite
    extends cdq {
        private final nf bucket = new nf("items/bucket_empty");
        private final nf bucketCoverMask = new nf("forge", "items/vanilla_bucket_cover_mask");
        private final ImmutableList<nf> dependencies = ImmutableList.of((Object)this.bucket, (Object)this.bucketCoverMask);

        private BucketCoverSprite(nf resourceLocation) {
            super(resourceLocation.toString());
        }

        public boolean hasCustomLoader(@Nonnull cep manager, @Nonnull nf location) {
            return true;
        }

        public Collection<nf> getDependencies() {
            return this.dependencies;
        }

        public boolean load(@Nonnull cep manager, @Nonnull nf location, @Nonnull Function<nf, cdq> textureGetter) {
            cdq sprite = textureGetter.apply(this.bucket);
            cdq alphaMask = textureGetter.apply(this.bucketCoverMask);
            this.f = sprite.c();
            this.g = sprite.d();
            int[][] pixels = new int[bib.z().t.K + 1][];
            pixels[0] = new int[this.f * this.g];
            try (ceo empty = LoaderDynBucket.getResource(new nf("textures/items/bucket_empty.png"));
                 ceo mask = LoaderDynBucket.getResource(new nf("forge", "textures/items/vanilla_bucket_cover_mask.png"));){
                if (empty != null && mask != null && Objects.equals(empty.d(), mask.d()) && alphaMask.c() == this.f && alphaMask.d() == this.g) {
                    int[][] oldPixels = sprite.a(0);
                    int[][] alphaPixels = alphaMask.a(0);
                    for (int p2 = 0; p2 < this.f * this.g; ++p2) {
                        int alphaMultiplier = alphaPixels[0][p2] >>> 24;
                        int oldPixel = oldPixels[0][p2];
                        int oldPixelAlpha = oldPixel >>> 24;
                        int newAlpha = oldPixelAlpha * alphaMultiplier / 255;
                        pixels[0][p2] = (oldPixel & 0xFFFFFF) + (newAlpha << 24);
                    }
                }
            }
            catch (IOException e) {
                FMLLog.log.error("Failed to close resource", (Throwable)e);
            }
            this.l();
            this.a.add(pixels);
            return false;
        }
    }

    private static final class BucketBaseSprite
    extends cdq {
        private final nf bucket = new nf("items/bucket_empty");
        private final ImmutableList<nf> dependencies = ImmutableList.of((Object)this.bucket);

        private BucketBaseSprite(nf resourceLocation) {
            super(resourceLocation.toString());
        }

        public boolean hasCustomLoader(@Nonnull cep manager, @Nonnull nf location) {
            return true;
        }

        public Collection<nf> getDependencies() {
            return this.dependencies;
        }

        public boolean load(@Nonnull cep manager, @Nonnull nf location, @Nonnull Function<nf, cdq> textureGetter) {
            cdq sprite = textureGetter.apply(this.bucket);
            this.f = sprite.c();
            this.g = sprite.d();
            int[][] pixels = sprite.a(0);
            this.l();
            this.a.add(pixels);
            return false;
        }
    }

    public static enum LoaderDynBucket implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public boolean accepts(nf modelLocation) {
            return modelLocation.b().equals("forge") && modelLocation.a().contains("forgebucket");
        }

        @Override
        public IModel loadModel(nf modelLocation) {
            return MODEL;
        }

        @Override
        public void a(cep resourceManager) {
        }

        public void register(cdp map) {
            try (ceo cover = LoaderDynBucket.getResource(new nf("forge", "textures/items/bucket_cover.png"));
                 ceo base = LoaderDynBucket.getResource(new nf("forge", "textures/items/bucket_base.png"));){
                if (cover == null) {
                    nf bucketCover = new nf("forge", "items/bucket_cover");
                    BucketCoverSprite bucketCoverSprite = new BucketCoverSprite(bucketCover);
                    map.setTextureEntry((cdq)bucketCoverSprite);
                }
                if (base == null) {
                    nf bucketBase = new nf("forge", "items/bucket_base");
                    BucketBaseSprite bucketBaseSprite = new BucketBaseSprite(bucketBase);
                    map.setTextureEntry((cdq)bucketBaseSprite);
                }
            }
            catch (IOException e) {
                FMLLog.log.error("Failed to close resource", (Throwable)e);
            }
        }

        @Nullable
        protected static ceo getResource(nf resourceLocation) {
            try {
                return bib.z().O().a(resourceLocation);
            }
            catch (IOException ignored) {
                return null;
            }
        }
    }
}

